/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Prefs {
    public Map<String, String> data = new HashMap<String, String>();
    public String dir;

    public String getString(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return "";
    }

    public String getString(String key, String def) {
        return this.data.getOrDefault(key, def);
    }

    public void putString(String key, String value) {
        this.data.put(key, value);
    }

    public int getInteger(String key) {
        if (this.data.containsKey(key)) {
            return Integer.valueOf(this.data.get(key));
        }
        return -999;
    }

    public int getInteger(String key, int def) {
        if (this.data.containsKey(key)) {
            return Integer.valueOf(this.data.get(key));
        }
        return def;
    }

    public void putInteger(String key, int value) {
        this.data.put(key, Integer.toString(value));
    }

    public float getFloat(String key, float def) {
        if (this.data.containsKey(key)) {
            return Float.valueOf(this.data.get(key)).floatValue();
        }
        return def;
    }

    public void putFloat(String key, float value) {
        this.data.put(key, Float.toString(value));
    }

    public long getLong(String key, long def) {
        if (this.data.containsKey(key)) {
            return Long.valueOf(this.data.get(key));
        }
        return def;
    }

    public void putLong(String key, long value) {
        this.data.put(key, Long.toString(value));
    }

    public boolean getBoolean(String key, boolean def) {
        if (this.data.containsKey(key)) {
            return Boolean.valueOf(this.data.get(key));
        }
        return def;
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.data.get(key));
    }

    public void putBoolean(String key, boolean value) {
        this.data.put(key, Boolean.toString(value));
    }

    public void flush() {
        System.out.println("Saving: " + this.dir);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileHandle file = Gdx.files.local(this.dir);
        file.writeString(gson.toJson(this.data), false, String.valueOf(StandardCharsets.UTF_8));
    }

    public void backupFlush() {
        System.out.println("Creating Backup: " + this.dir);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileHandle file = Gdx.files.local("backup" + File.separator + this.dir);
        file.writeString(gson.toJson(this.data), false, String.valueOf(StandardCharsets.UTF_8));
    }

    public Map<String, String> get() {
        return this.data;
    }
}

